using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class TotemRecharger : Item
	{
      [Constructable]
		public TotemRecharger() : base( 13901 )
		{
			Weight = 50.0;
			Name = "unholy totem";
			Movable = false;
		}

		public TotemRecharger( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !from.InRange( this, 2 ) || !from.InLOS( this ) )
				from.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
			else
			{
				from.SendMessage( "Vyber skull of totem summoning pro dobiti" );
				from.SendMessage( 34, "Dobijena lebka bude linknuta na tebe" );
				from.Target = new TotemRechargerTarget( this );
			}
		}
		
		private class TotemRechargerTarget : Target
		{
			private TotemRecharger m_Recharger;

			public TotemRechargerTarget( TotemRecharger rech ) : base( 1, false, TargetFlags.None )
			{
				m_Recharger = rech;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is BaseTotemSummoner ) )
				{
					from.SendMessage( "Dobijet lze pouze skull of totem summoning" );
					return;
				}
				
				BaseTotemSummoner skull = (BaseTotemSummoner) target;
					
				if ( skull == null || skull.Charges >= 75 )
					from.SendMessage( "Maximalni pocet nabiti je 75!" );
				else if( !skull.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit {0} v batohu", skull.Name );
            else if( skull.BlessedFor != null && skull.BlessedFor != from )
					from.SendMessage( "Toto neni tvoje {0}", skull.Name );
				else
				{
					skull.Charges = 75;
					skull.BlessedFor = from;
               Effects.PlaySound( m_Recharger.Location, m_Recharger.Map, 0x202 );
               Effects.SendLocationParticles( EffectItem.Create( m_Recharger.Location, m_Recharger.Map, EffectItem.DefaultDuration ), 0x376A, 8, 20, 5042 );
               from.FixedParticles( 14170, 1, 10, 0x1F78, m_Recharger.Hue, 5, EffectLayer.Waist );
					from.PlaySound( 0x5BC );
					from.PlaySound( 0x5C0 );
					from.SendMessage( "{0} byla nabita na 75 pouziti", skull.Name );
				}
			}
		}
	}
}


